﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class PlayerShoot : MonoBehaviour {

    public static PlayerShoot instance;

    public GameObject bullet1;
    public GameObject bullet2;
    public GameObject bullet3;

    public Transform bulletSpawn1;
    public Transform bulletSpawn2;
    public Transform bulletSpawn3;

    public GameObject spawn1;
    public GameObject spawn2;
    public GameObject spawn3;

    public float fireRate = 0.5f;
    private float fireNext = 0.75f;

    public AudioSource audioSource;
    public AudioClip playerShoot;

    void Start () {
        MakeInstance();
        FireBullets();
        spawn1.SetActive(false);
        spawn3.SetActive(false);
    }

    void MakeInstance() {
        if (instance == null)
            instance = this;
    }

    void Update() {
        FireBullets();
    }

    public void FireBullets()
    {
        if (Time.time >= fireNext) {
           
            fireNext = Time.time + fireRate;
            audioSource.PlayOneShot(playerShoot);

            spawn1 = Instantiate(bullet1, bulletSpawn1.position, bulletSpawn1.rotation) as GameObject;
            Destroy(spawn1, 2f);
          
            spawn2 = Instantiate(bullet2, bulletSpawn2.position, bulletSpawn2.rotation) as GameObject;

            spawn3 = Instantiate(bullet3, bulletSpawn3.position, bulletSpawn3.rotation) as GameObject;
            Destroy(spawn3, 2f);
        }
    }   

}
